//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.data.Core 1.0

import wesual.Ui       1.0
import wesual.Controls 1.0

Item {
    id : tabs

    implicitHeight : 36
    implicitWidth  : tabWidth * Math.max(1, repeater.count)

    property string currentLanguage : ""
    property int   tabWidth     : 42
    property alias languageListing : repeater.model
    property var   enabledFlags : []
    property color background : UI.color(UI.PrimaryBase)

    Row {
        spacing : 2

        Repeater {
            id : repeater

            delegate : Rectangle {
                id : delegate

                readonly property string language :
                    modelData.code
                readonly property bool flagEnabled :
                    enabledFlags.indexOf(language) !== -1

                width  : tabs.tabWidth
                height : tabs.height
                color : {
                    if (language === tabs.currentLanguage)
                        return UI.color(UI.PrimaryPress);
                    else if (mouseArea.pressed)
                        return UI.color(UI.PrimaryPress);
                    else if (mouseArea.containsMouse)
                        return UI.color(UI.PrimaryHover);
                    else
                        return background;
                }

                Rectangle {
                    id : flagContainer

                    width  : flag.sourceSize.width  + 2
                    height : flag.sourceSize.height - 4
                    color  : UI.color(UI.PrimaryBase)
                    anchors.centerIn : parent

                    Image {
                        id : flag

                        sourceSize {
                            width : 24
                            height : 24
                        }

                        anchors.centerIn : parent
                        source : modelData.flag
                    }
                    Rectangle {
                        anchors.centerIn: flag
                        width : 22
                        height : 16
                        color   : UI.color(UI.LanguagesOverlay)
                        opacity : delegate.flagEnabled ? 0.0 : 0.5
                    }
                }
                MouseArea {
                    id : mouseArea

                    anchors.fill : parent
                    hoverEnabled : true
                    onClicked    : currentLanguage = language
                    cursorShape  : Qt.PointingHandCursor
                }
            }
        }
    }
}
